<?php
include_once("conexion.php");

class Expediente{

    function listar($nroexpediente, $estado, $origen,$idareaorigen){
        $sql = "SELECT DISTINCT e.*,c.nombre FROM expedientes e 
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        INNER JOIN movimiento_expediente m on m.idexpediente=e.idexpediente
        INNER JOIN areas a on a.idarea=m.idareaorigen
        WHERE e.estado<2 AND (e.nroexpediente LIKE :nroexpediente OR e.asunto LIKE :nroexpediente OR c.nombre LIKE :nroexpediente)  AND e.origen = :origen and m.idareaorigen= :idareaorigen AND m.idmovimiento=1";
        $parametros = array(':nroexpediente'=>$nroexpediente,':origen'=>$origen, ':idareaorigen'=>$idareaorigen);
        if($estado!=""){
            $sql.=" AND e.estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY e.idexpediente DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function listarMovimientoExpediente($expediente){
        $sql = "SELECT c.nombre as cliente,m.idMovimiento,a.nombre as areaOrigen,a2.nombre as areaDestino,t.nombretipotramite,m.fechaMovimiento,(DATEDIFF(e.fechasys,m.fechaMovimiento)*-1) as dias,m.proveido,e.diasatencion,m.idExpediente,u.usuario
        FROM movimiento_expediente m  
                              inner join areas a on a.idarea=m.idareaorigen
                              inner join areas a2 on a2.idarea=m.idareadestino
                              inner join tipotramite t on t.idtramite=m.idTramite 
                              inner join expedientes e on e.idexpediente=m.idexpediente
                              inner join cliente c on c.idcliente=e.idcliente
                              inner join usuario u on u.idusuario=m.idusuario
                              WHERE m.idexpediente=:expediente ";

        $parametros = array(':expediente'=>$expediente);

        $sql.=" ORDER BY m.idMovimiento ASC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }


    function clienteMovimientoExpediente($expediente){
        $sql = "SELECT c.nombre as cliente 
        FROM expedientes e 
        inner join cliente c on c.idcliente=e.idcliente
        WHERE e.idexpediente=:expediente ";

        $parametros = array(':expediente'=>$expediente);

        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function fechaExpediente($expediente){
        $sql = "SELECT e.fechaexpediente as fechainicio 
        FROM expedientes e 
       
        WHERE e.idexpediente=:expediente ";

        $parametros = array(':expediente'=>$expediente);

        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function nroExpediente($expediente){
        $sql = "SELECT e.nroexpediente as nroexpediente, e.asunto as asunto 
        FROM expedientes e 
       
        WHERE e.idexpediente=:expediente ";

        $parametros = array(':expediente'=>$expediente);

        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function constanciaExpediente($expediente){
        $sql = "SELECT e.*,c.nombre as cliente
        FROM expedientes e  
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        WHERE e.idexpediente=:expediente ";

        $parametros = array(':expediente'=>$expediente);

        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }


    function consultarExpediente($idexpediente){
        $sql = "SELECT * FROM expedientes WHERE idexpediente=? ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($idexpediente));
        return $pre;
    }

    function listarExpedienteModal($idexpediente){
        $sql = "SELECT id,idexpediente,link,nombre FROM expedientes_links WHERE idexpediente=:expediente ";
        $parametros = array(':expediente'=>$idexpediente);
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function consultarExpedientenroDocumento($nroexpediente, $idexpediente=0){
        $sql = "SELECT * FROM expedientes WHERE nroexpediente=? AND idexpediente<>?";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($nroexpediente,$idexpediente));
        return $pre;
    }

    function insertar($idexpediente,$origen,$idcliente, $fechasys, $fechaexpediente,$idtipodoc,$nroexpediente,$asunto,$detalle,$folios,$link,$diasatencion,$idarea,$idtramite,$proveido, $estado){
        $sql = "INSERT INTO expedientes 
                VALUES (:idexpediente,:origen, :idcliente, :fechasys, :fechaexpediente,:idtipodoc,:nroexpediente,:asunto,:detalle,:folios,:link,:diasatencion,:idarea,:idtramite,:proveido, :estado)";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":origen"=>$origen,
                        ":idcliente"=>$idcliente,
                        ":fechasys"=>$fechasys,
                        ":fechaexpediente"=>$fechaexpediente, 
                        ":idtipodoc"=>$idtipodoc, 
                        ":nroexpediente"=>$nroexpediente, 
                        ":asunto"=>$asunto, 
                        ":detalle"=>$detalle, 
                        ":folios"=>$folios, 
                        ":link"=>$link, 
                        ":diasatencion"=>$diasatencion, 
                        ":idarea"=>$idarea, 
                        ":idtramite"=>$idtramite, 
                        ":proveido"=>$proveido, 
                        ":estado"=>$estado
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function insertarmovimientoexpediente($idmovimiento,$idexpediente,$idareaorigen,$idareadestino,$idTramite,$fechamovimiento,$proveido,$detalle,$idusuario){
        $sql = "INSERT INTO movimiento_expediente 
        VALUES (:idmovimiento,:idexpediente,:idareaorigen,:idareadestino,:idTramite,:fechamovimiento,:proveido,:detalle,:idusuario)";
        global $cnx;
        $parametros = array(
                ":idmovimiento"=>$idmovimiento,
                ":idexpediente"=>$idexpediente,
                ":idareaorigen"=>$idareaorigen,
                ":idareadestino"=>$idareadestino, 
                ":idTramite"=>$idTramite, 
                ":fechamovimiento"=>$fechamovimiento, 
                ":proveido"=>$proveido, 
                ":detalle"=>$detalle,
                ":idusuario"=>$idusuario, 
                
            );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizar($idexpediente, $origen,$idcliente, $fechasys, $fechaexpediente,$idtipodoc,$nroexpediente,$asunto,$detalle,$folios,$link,$diasatencion,$idarea,$idtramite,$proveido, $estado){
        $sql = "UPDATE expedientes 
                SET origen=:origen, 
                    idcliente=:idcliente,
                    fechasys=:fechasys,
                    fechaexpediente=:fechaexpediente,
                    idtipodoc=:idtipodoc,
                    nroexpediente=:nroexpediente,
                    asunto=:asunto,
                    detalle=:detalle,
                    folios=:folios,
                    link=:link,
                    diasatencion=:diasatencion,
                    idarea=:idarea,
                    idtramite=:idtramite,
                    proveido=:proveido,
                    estado=:estado 
                WHERE idexpediente=:idexpediente";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente, 
                        ":origen"=>$origen,
                        ":idcliente"=>$idcliente,
                        ":fechasys"=>$fechasys,
                        ":fechaexpediente"=>$fechaexpediente, 
                        ":idtipodoc"=>$idtipodoc, 
                        ":nroexpediente"=>$nroexpediente, 
                        ":asunto"=>$asunto, 
                        ":detalle"=>$detalle, 
                        ":folios"=>$folios, 
                        ":link"=>$link, 
                        ":diasatencion"=>$diasatencion, 
                        ":idarea"=>$idarea, 
                        ":idtramite"=>$idtramite, 
                        ":proveido"=>$proveido, 
                        ":estado"=>$estado
                    );
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function derivar($idexpediente,$idareaorigen,$idareadestino){
        $sql = "INSERT INTO movimiento_derivados 
                VALUES (:idexpediente,:idareaorigen, :idareadestino)";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareaorigen"=>$idareaorigen,
                        ":idareadestino"=>$idareadestino
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function recibir($idexpediente,$idtramite,$idareaorigen){
        $sql = "UPDATE expedientes SET idTramite=:idtramite,idArea=:idareaorigen
                WHERE idexpediente=:idexpediente";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idtramite"=>$idtramite,
                        ":idareaorigen"=>$idareaorigen
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function eliminarRecibido($idexpediente,$idareaorigen){
        $sql = "DELETE FROM movimiento_porrecibir 
                WHERE idexpediente=:idexpediente AND idareadestino=:idareadestino" ;
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareadestino"=>$idareaorigen
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function eliminarLink($id,$idexpediente){
        $sql = "DELETE FROM expedientes_links 
                WHERE idexpediente=:idexpediente AND id=:id" ;
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":id"=>$id
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function eliminarDerivado($idexpediente,$idareaorigen){
        $sql = "DELETE FROM movimiento_derivados 
                WHERE idexpediente=:idexpediente AND idareadestino=:idareadestino" ;
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareadestino"=>$idareaorigen
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function eliminarmovimientoenproceso($idexpediente,$idareaorigen){
        $sql = "DELETE FROM movimiento_enproceso
                WHERE idexpediente=:idexpediente AND idarea=:idareadestino" ;
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareadestino"=>$idareaorigen
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function insertarmovimientoPorRecibir($idexpediente,$idareaorigen,$idareadestino){
        $sql = "INSERT INTO movimiento_porrecibir 
                VALUES (:idexpediente,:idareaorigen, :idareadestino)";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareaorigen"=>$idareaorigen,
                        ":idareadestino"=>$idareadestino
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function insertarmovimientoenproceso($idexpediente,$idareaorigen){
        $sql = "INSERT INTO movimiento_enproceso
                VALUES (:idexpediente,:idareaorigen)";
        global $cnx;
        $parametros = array(
                        ":idexpediente"=>$idexpediente,
                        ":idareaorigen"=>$idareaorigen
                        
                       
                    );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarEstado($idexpediente, $estado){
        $sql = "UPDATE expedientes SET estado=:estado WHERE idexpediente=:idexpediente";
        global $cnx;
        $parametros = array(":idexpediente"=>$idexpediente, ":estado"=>$estado);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarDerivado($idexpediente,$idtramite,$proveido){
        $sql = "UPDATE expedientes SET idTramite=:idtramite,proveido=:proveido WHERE idexpediente=:idexpediente";
        global $cnx;
        $parametros = array(":idexpediente"=>$idexpediente, ":idtramite"=>$idtramite,":proveido"=>$proveido);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarUrldocumento($idexpediente, $urldocumento){
        $sql = "UPDATE expedientes SET link=:urldocumento WHERE idexpediente=:idexpediente";
        global $cnx;
        $parametros = array(":idexpediente"=>$idexpediente, ":urldocumento"=>$urldocumento);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarTablaLinks($idcorrelativo,$idexpediente, $urldocumento,$nombre){
        $sql = "INSERT INTO expedientes_links VALUES (:idexpediente,:urldocumento, :nombre,:idcorrelativo)";
        global $cnx;
        $parametros = array(":idexpediente"=>$idexpediente, ":urldocumento"=>$urldocumento, ":nombre"=>$nombre,":idcorrelativo"=>$idcorrelativo);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function obteneridCorrelativo(){
        $sql = "SELECT idExpediente as codigo FROM expedientes ORDER BY idExpediente DESC LIMIT 1 ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array());
        if($pre->rowCount()>0){
            $pre = $pre->fetch(PDO::FETCH_NUM);
            $pre = $pre[0]+1;
        }else{
            $pre = 1;
        }
        return $pre;
    }

    function obteneridCorrelativoLink(){
        $sql = "SELECT id as codigo FROM expedientes_links ORDER BY id DESC LIMIT 1 ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array());
        if($pre->rowCount()>0){
            $pre = $pre->fetch(PDO::FETCH_NUM);
            $pre = $pre[0]+1;
        }else{
            $pre = 1;
        }
        return $pre;
    }

    function obteneridCorrelativoMovimiento($idexpediente){
        $sql = "SELECT idmovimiento as idmovimiento FROM movimiento_expediente WHERE idExpediente='$idexpediente'
        ORDER BY idmovimiento  DESC LIMIT 1 ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array());
        if($pre->rowCount()>0){
            $pre = $pre->fetch(PDO::FETCH_NUM);
            $pre = $pre[0]+1;
        }else{
            $pre = 1;
        }
        return $pre;
    }

    function cantidadExpedientesenProceso($idarea){
        $sql = "SELECT count(DISTINCT e.idexpediente) as numero FROM expedientes e 
        inner join movimiento_enproceso m on m.idexpediente=e.idexpediente 
        WHERE e.estado<2 and m.idarea=$idarea ORDER BY e.idExpediente";
        $parametros = array(":fecha"=>$idarea);
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute();
        return $pre;         
    }

    function listarEnProceso($nroexpediente, $estado, $idTramite,$idarea){
        $sql = "SELECT DISTINCT e.*,c.nombre FROM expedientes e 
        INNER JOIN movimiento_enproceso m ON m.idexpediente=e.idexpediente
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        WHERE (e.nroexpediente LIKE :nroexpediente OR e.asunto LIKE :nroexpediente OR c.nombre LIKE :nroexpediente)  and m.idarea=:idarea ";
        $parametros = array(':nroexpediente'=>$nroexpediente,':idarea'=>$idarea);

        $sql.=" ORDER BY e.idexpediente DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function cantidadExpedientesDerivados($idarea){
        $sql = "SELECT count(m.idexpediente) as numero FROM movimiento_derivados m 
        INNER JOIN expedientes e ON e.idexpediente=m.idexpediente
                        WHERE m.idAreaorigen=$idarea and e.estado=1 ";
        //$parametros = array(":fecha"=>$idarea);
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute();
        return $pre;         
    }

    function cantidadExpedientesPorRecibir($idarea){
        $sql = "SELECT count(r.idexpediente) as numero FROM movimiento_porrecibir r 
        inner join expedientes e on e.idexpediente=r.idexpediente
                        WHERE r.idareadestino=$idarea and e.estado=1; ";
        $parametros = array(":fecha"=>$idarea);
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;         
    }

    function cantidadExpedientesArchivados($idarea){
        $sql = "SELECT count(DISTINCT e.idexpediente) as numero FROM expedientes e 
        inner join movimiento_expediente m on m.idexpediente=e.idexpediente 
        WHERE m.idAreaOrigen=$idarea and m.idTramite=3 and e.estado ORDER BY e.idExpediente";
        $parametros = array(":fecha"=>$idarea);
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;         
    }



    function listarDerivados($nroexpediente, $estado, $idTramite,$idarea){
        $sql = "SELECT DISTINCT e.*,c.nombre,ad.nombre as areadestino FROM expedientes e 
        INNER JOIN movimiento_derivados m ON m.idexpediente=e.idexpediente
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        INNER JOIN areas a on a.idarea=e.idarea
        INNER JOIN areas ad ON m.idareadestino=ad.idarea
        INNER JOIN movimiento_expediente me ON me.idareaorigen=m.idareaorigen and me.idexpediente=m.idexpediente
        WHERE e.estado<2 AND e.nroexpediente LIKE :nroexpediente AND me.idTramite = :idTramite and me.idareaorigen=:idarea ";
        $parametros = array(':nroexpediente'=>$nroexpediente,':idTramite'=>$idTramite,':idarea'=>$idarea);
        if($estado!=""){
            $sql.=" AND e.estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY e.idexpediente DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function listarporRecibir($nroexpediente, $estado, $idTramite,$idarea){
        $sql = "SELECT DISTINCT e.*,c.nombre,ad.nombre as areaorigen FROM expedientes e 
        INNER JOIN movimiento_porrecibir m ON m.idexpediente=e.idexpediente
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        INNER JOIN areas a on a.idarea=m.idareadestino
        INNER JOIN areas ad ON m.idareaorigen=ad.idarea
        INNER JOIN movimiento_expediente me ON me.idareadestino=m.idareadestino and me.idexpediente=m.idexpediente
        WHERE e.estado<2 AND e.nroexpediente LIKE :nroexpediente AND me.idTramite = :idTramite and m.idareadestino=:idarea ";
        $parametros = array(':nroexpediente'=>$nroexpediente,':idTramite'=>$idTramite,':idarea'=>$idarea);
        if($estado!=""){
            $sql.=" AND e.estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY e.idexpediente DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function listarArchivados($nroexpediente, $estado, $idTramite,$idarea){
        $sql = "SELECT DISTINCT e.*,c.nombre FROM expedientes e 
        INNER JOIN movimiento_expediente m ON m.idexpediente=e.idexpediente
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        WHERE (e.nroexpediente LIKE :nroexpediente OR e.asunto LIKE :nroexpediente OR c.nombre LIKE :nroexpediente) AND m.idTramite = :idTramite and m.idareaOrigen=:idarea ";
        
        $parametros = array(':nroexpediente'=>$nroexpediente,':idTramite'=>$idTramite,':idarea'=>$idarea);
        if($estado!=""){
            $sql.=" AND e.estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY e.idexpediente DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function listarMovimientogeneral($desde,$hasta){
        $sql = "SELECT DISTINCT(e.idexpediente)idexpediente,e.fechaexpediente,e.nroexpediente,c.nombre,c.cargo,e.asunto,a.nombre as area,e.proveido  FROM expedientes e
        INNER JOIN cliente c ON c.idcliente=e.idcliente
        INNER JOIN areas a on a.idarea=e.idarea
        WHERE e.fechasys between :desde and :hasta and e.estado=1";

        $parametros = array(':desde'=>$desde,':hasta'=>$hasta);

        $sql.=" ORDER BY e.idexpediente ASC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }


}



?>