<?php
require_once("conexion.php");

class TipoDocumento{
function listarDocumentos(){
        $sql = "SELECT * FROM tipodocumento";
        global $cnx;
        $resultado = $cnx->query($sql);
        return $resultado;
    }
}

function consultarTipoDocumento($idtipodocumento){
    $sql = "SELECT * FROM tipodocumento WHERE idtipodocumento=? ";
    global $cnx;
    $pre = $cnx->prepare($sql);
    $pre->execute(array($idtipodocumento));
    return $pre;
}

function consultarTipodocumentoNombre($nombre, $idtipodocumento=0){
    $sql = "SELECT * FROM tipodocumento WHERE nombre=? AND idtipodocumento<>?";
    global $cnx;
    $pre = $cnx->prepare($sql);
    $pre->execute(array($nombre,$idtipodocumento));
    return $pre;
}

function insertar($nombre, $estado){
    $sql = "INSERT INTO tipodocumento VALUES (NULL,:nombre, :estado)";
    global $cnx;
    $parametros = array(":nombre"=>$nombre, ":estado"=>$estado);
    $pre = $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}

function actualizar($idtipodocumento, $nombre, $estado){
    $sql = "UPDATE tipodocumento 
            SET nombre=:nombre, estado=:estado 
            WHERE idtipodocumento=:idtipodocumento";
    global $cnx;
    $parametros = array(":idtipodocumento"=>$idtipodocumento, ":nombre"=>$nombre, ":estado"=>$estado);
    $pre= $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}

function actualizarEstado($idtipodocumento, $estado){
    $sql = "UPDATE tipodocumento SET estado=:estado WHERE idtipodocumento=:idtipodocumento";
    global $cnx;
    $parametros = array(":idtipodocumento"=>$idtipodocumento, ":estado"=>$estado);
    $pre= $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}    


?>