<?php
include_once("conexion.php");

class Venta{

    function listar($desde, $hasta, $cliente){
        $sql = "SELECT v.idventa, v.fecha, v.serie, v.correlativo, v.total, tc.nombre comprobante,
                        c.nombre cliente 
                FROM venta v INNER JOIN tipocomprobant tc ON v.idtipocomprobante=tc.idtipocomprobante
                LEFT JOIN cliente c ON v.idcliente=c.idcliente
                WHERE v.estado<2 AND c.nombre LIKE :cliente ";
        $parametros = array(':cliente'=>$cliente);
        if($desde!=""){
            $sql.=" AND v.fecha>=:desde ";
            $parametros[':desde']=$desde;
        }
        if($hasta!=""){
            $sql.=" AND v.fecha<=:hasta ";
            $parametros[':hasta']=$hasta;
        }

        $sql.=" ORDER BY V.fecha DESC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function consultarVenta($idventa){
        $sql = "SELECT * FROM venta WHERE idventa=? ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($idventa));
        return $pre;
    }

    function consultarVentaExistente($idtipocomprobante, $serie, $correlativo, $idventa=0){
        $sql = "SELECT * FROM venta WHERE iditpocomprobante=? AND serie=? 
                AND correlativo=? AND idventa<>?";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($idtipocomprobante,$serie, $correlativo, $idventa));
        return $pre;
    }

    function insertar($venta){
        $sql = "INSERT INTO 
                venta(idventa, fecha, idcliente, idtipocomprobante, serie, correlativo,
                    total, total_gravado, total_exonerado, total_inafecto, total_igv,
                    total_icbper, total_descuento, formapago, idmoneda, vencimiento, 
                    guiaremision, ordencompra, idusuario, estado) 
                VALUES (NULL,:fecha, :idcliente, :idtipocomprobante, :serie, :correlativo,
                    :total, :total_gravado, :total_exonerado, :total_inafecto, :total_igv,
                    :total_icbper, :total_descuento, :formapago, :idmoneda, :vencimiento, 
                    :guiaremision, :ordencompra, :idusuario, :estado)";
        global $cnx;
        $parametros = array(
            ":fecha"            =>$venta["fecha"], 
            ":idcliente"        =>$venta["idcliente"], 
            ":idtipocomprobante"=>$venta["idtipocomprobante"], 
            ":serie"            =>$venta["serie"], 
            ":correlativo"      =>$venta["correlativo"], 
            ":total"            =>$venta["total"], 
            ":total_gravado"    =>$venta["total_gravado"],    
            ":total_exonerado"  =>$venta["total_exonerado"], 
            ":total_inafecto"   =>$venta["total_inafecto"], 
            ":total_igv"        =>$venta["total_igv"],
            ":total_icbper"     =>$venta["total_icbper"], 
            ":total_descuento"  =>$venta["total_descuento"], 
            ":formapago"        =>$venta["formapago"], 
            ":idmoneda"         =>$venta["idmoneda"], 
            ":vencimiento"      =>$venta["vencimiento"], 
            ":guiaremision"     =>$venta["guiaremision"], 
            ":ordencompra"      =>$venta["ordencompra"], 
            ":idusuario"        =>$_SESSION["idusuario"], 
            ":estado"           =>1
        );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function insertarDetalle($detalle){
        $sql = "INSERT INTO detalle(iddetalle, idventa, idproducto, cantidad, unidad,
                            pventa, igv, icbper, descuento, total, idafectacion, estado)
                VALUES (NULL, :idventa, :idproducto, :cantidad, :unidad,
                            :pventa, :igv, :icbper, :descuento, :total, :idafectacion, :estado)";
        global $cnx;
        $pre = $cnx->prepare($sql);
        foreach($detalle as $k=>$v){
            $parametros = array(
                ":idventa"      =>$v["idventa"], 
                ":idproducto"   =>$v["idproducto"], 
                ":cantidad"     =>$v["cantidad"], 
                ":unidad"       =>$v["unidad"],
                ":pventa"       =>$v["pventa"], 
                ":igv"          =>$v["igv"], 
                ":icbper"       =>$v["icbper"], 
                ":descuento"    =>$v["descuento"], 
                ":total"        =>$v["total"], 
                ":idafectacion" =>$v["idafectacion"], 
                ":estado"       =>1
            );  
        }
    }

    function cambiarEstadoDetalle($idventa, $estado){
        $sql = "UPDATE detalle SET estado=:estado WHERE idventa=:idventa AND estado<>2";
        global $cnx;
        $parametros = array(':idventa'=>$idventa,':estado'=>$estado);
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizar($venta){
        $sql = "UPDATE venta 
                SET fecha=:fecha, idcliente=:idcliente, idtipocomprobante=:idtipocomprobante,
                    serie=:serie, correlativo=:correlativo, total=:total, 
                    total_gravado=:total_gravado, total_exonerado=:total_exonerado, 
                    total_inafecto=:total_inafecto, total_igv=:total_igv,
                    total_icbper=:total_icbper, total_descuento=:total_descuento, 
                    formapago=:formapago, idmoneda=:idmoneda, vencimiento=:vencimiento, 
                    guiaremision=:guiaremision, ordencompra=:ordencompra, 
                    idusuario=:idusuario, estado=:estado 
                WHERE idventa=:idventa";
        global $cnx;
        $parametros = array(
            ":idventa"          =>$venta["idventa"],
            ":fecha"            =>$venta["fecha"], 
            ":idcliente"        =>$venta["idcliente"], 
            ":idtipocomprobante"=>$venta["idtipocomprobante"], 
            ":serie"            =>$venta["serie"], 
            ":correlativo"      =>$venta["correlativo"], 
            ":total"            =>$venta["total"], 
            ":total_gravado"    =>$venta["total_gravado"],    
            ":total_exonerado"  =>$venta["total_exonerado"], 
            ":total_inafecto"   =>$venta["total_inafecto"], 
            ":total_igv"        =>$venta["total_igv"],
            ":total_icbper"     =>$venta["total_icbper"], 
            ":total_descuento"  =>$venta["total_descuento"], 
            ":formapago"        =>$venta["formapago"], 
            ":idmoneda"         =>$venta["idmoneda"], 
            ":vencimiento"      =>$venta["vencimiento"], 
            ":guiaremision"     =>$venta["guiaremision"], 
            ":ordencompra"      =>$venta["ordencompra"], 
            ":idusuario"        =>$_SESSION["idusuario"], 
            ":estado"           =>1
        );
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarEstado($idventa, $estado){
        $sql = "UPDATE venta SET estado=:estado WHERE idventa=:idventa";
        global $cnx;
        $parametros = array(":idventa"=>$idventa, ":estado"=>$estado);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function consultarSeries($idtipocomprobante){
        $sql = "SELECT * FROM serie WHERE idtipocomprobante=?";
        global $cnx;
        $pre= $cnx->prepare($sql);
        $pre->execute(array($idtipocomprobante));
        return $pre;        
    }
}

?>