<?php
include_once("conexion.php");

class Area{

    function listar($nombre, $estado){
        $sql = "SELECT * FROM areas WHERE estado<2 AND nombre LIKE :nombre ";
        $parametros = array(':nombre'=>$nombre);
        if($estado!=""){
            $sql.=" AND estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY nombre ASC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function consultarArea($idarea){
        $sql = "SELECT * FROM areas WHERE idarea=? ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($idarea));
        return $pre;
    }

    function consultarAreaNombre($nombre, $idarea=0){
        $sql = "SELECT * FROM areas WHERE nombre=? AND idarea<>?";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($nombre,$idarea));
        return $pre;
    }

    function insertar($idcorrelativo,$nombre,$representante, $estado){
        $sql = "INSERT INTO areas VALUES (:id,:nombre, :representante, :estado)";
        //$sql = "INSERT INTO categoria(nombre, estado) VALUES (:nombre, :estado)";
        global $cnx;
        $parametros = array("id"=>$idcorrelativo,":nombre"=>$nombre,":representante"=>$representante, ":estado"=>$estado);
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizar($idarea, $nombre,$representante, $estado){
        $sql = "UPDATE areas 
                SET nombre=:nombre,representante=:representante, estado=:estado 
                WHERE idarea=:idarea";
        global $cnx;
        $parametros = array(":idarea"=>$idarea, ":nombre"=>$nombre,":representante"=>$representante, ":estado"=>$estado);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarEstado($idarea, $estado){
        $sql = "UPDATE areas SET estado=:estado WHERE idarea=:idarea";
        global $cnx;
        $parametros = array(":idarea"=>$idarea, ":estado"=>$estado);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function obteneridCorrelativo(){
        $sql = "SELECT idarea as codigo FROM areas ORDER BY idarea DESC LIMIT 1 ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array());
        if($pre->rowCount()>0){
            $pre = $pre->fetch(PDO::FETCH_NUM);
            $pre = $pre[0]+1;
        }else{
            $pre = 1;
        }
        return $pre;
    }
}

?>