<?php
require_once("conexion.php");

class TipoDocumentoTramite{
function listarDocumentosTramite($nombre, $estado){
        $sql = "SELECT * FROM tipodocumentotramite WHERE estado<2 AND nombre LIKE :nombre ";
        $parametros = array(':nombre'=>$nombre);
        if($estado!=""){
            $sql.=" AND estado=:estado ";
            $parametros[':estado']=$estado;
        }
        $sql.=" ORDER BY nombre ASC";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

function consultarTipoDocumentoTramite($idtipodoc){
    $sql = "SELECT * FROM tipodocumentotramite WHERE idtipodoc=? ";
    global $cnx;
    $pre = $cnx->prepare($sql);
    $pre->execute(array($idtipodoc));
    return $pre;
}

function consultarTipoDocumentoTramiteNombre($nombre, $idtipodoc=0){
    $sql = "SELECT * FROM tipodocumentotramite WHERE nombre=? AND idtipodoc<>?";
    global $cnx;
    $pre = $cnx->prepare($sql);
    $pre->execute(array($nombre,$idtipodoc));
    return $pre;
}

function insertar($nombre, $estado){
    $sql = "INSERT INTO tipodocumentotramite VALUES (NULL,:nombre, :estado)";
    global $cnx;
    $parametros = array(":nombre"=>$nombre, ":estado"=>$estado);
    $pre = $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}

function actualizar($idtipodoc, $nombre, $estado){
    $sql = "UPDATE tipodocumentotramite 
            SET nombre=:nombre, estado=:estado 
            WHERE idtipodoc=:idtipodoc";
    global $cnx;
    $parametros = array(":idtipodoc"=>$idtipodoc, ":nombre"=>$nombre, ":estado"=>$estado);
    $pre= $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}

function actualizarEstado($idtipodoc, $estado){
    $sql = "UPDATE tipodocumentotramite SET estado=:estado WHERE idtipodoc=:idtipodoc";
    global $cnx;
    $parametros = array(":idtipodoc"=>$idtipodoc, ":estado"=>$estado);
    $pre= $cnx->prepare($sql);
    $pre->execute($parametros);
    return $pre;
}    
}

?>