<?php 
include_once("../modelo/Area.php");
$objArea = new Area();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$listado = $objArea->listar("%".$filtro."%",$estado);
?>
<table id="tablaCategoria" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Represent.</th>
            <th>Estado</th>
            <th>Editar</th>
            <th>Anular</th>
            <th>Eliminar</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==1?"Anular":"Activar";
            $estado = $v['estado']==1?0:1;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idarea'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['representante'] ?></td>
                <td><?= $v['estado']==1?"ACTIVO":"INACTIVO"; ?></td>
                <td><button onclick="EditarArea(<?= $v['idarea'] ?>)" class="btn bg-info btn-sm">Editar</button></td>
                <td><button onclick="CambiarEstadoArea(<?= $v['idarea'] ?>,<?= $estado ?>,'<?= $v['nombre'] ?>')" class="btn <?= $bgclass ?> btn-sm"><?= $texto ?></button></td>
                <td><button onclick="CambiarEstadoArea(<?= $v['idarea'] ?>,2,'<?= $v['nombre'] ?>')" class="btn bg-danger btn-sm">Eliminar</button></td>
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaArea').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[1,'asc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaArea_wrapper .col-md-6:eq(0)');

function EditarArea(idarea){
    //01) primero obtengo los datos de la categoria
    $.ajax({
        method: "POST",
        url: "controlador/contArea.php",
        data:{
            'proceso': "CONSULTAR",
            'idarea': idarea
        },
        dataType: "json"
    }).done(function(resultado){
        //02) completo el formulario con los datos de la cateogoría
        $("#nombre").val(resultado.nombre);
        $("#representante").val(resultado.representante);
        $("#estado").val(resultado.estado);
        $("#idarea").val(resultado.idarea);
        //03) muestro el modal
        $("#modalArea").modal('show');
    });
}

function CambiarEstadoArea(idarea, estado, nombre){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> Area <b>"+nombre+"</b>?";
    accion = "EjecutarCambiarEstadoArea("+idarea+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoArea(idarea,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contArea.php",
        data: {
            'proceso': proceso,
            'idarea': idarea
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarAreas();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}
</script>