<?php 

include_once("../modelo/TipoDocumento.php");
include_once("../modelo/TipoDocumentoTramite.php");

$objTD = new TipoDocumento();
$documentos = $objTD->listarDocumentos();
$objTR = new TipoDocumentoTramite();
$documentosTR = $objTR->listarDocumentosTramite("%%",1);
$idArea=$_SESSION['idarea'];

include_once("../modelo/Area.php");
$objArea=new Area();
$areas = $objArea->listar("%%",1);


?>
<section class="content mt-2">
    <div class="container-fluid">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Expedientes ARCHIVADOS</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text">N°Documento</span>
                            </div>
                            <input type="text" class="form-control" 
                              placeholder="N° Documento" id="txtFiltroExpediente" name="txtFiltroExpediente"
                              >
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Estado</span>
                            </div>
                            <select class="form-control" id="cboFiltroEstado" name="cboFiltroEstado" onchange="listarExpedientes();">
                                <option value="">Todos</option>
                                <option value="1">Activos</option>
                                <option value="0">Inactivos</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                     <button type="button" class="btn btn-info" onclick="listarExpedientes();">Buscar</button> 
                    
                    </div>
                </div>
                <div id="divListadoProceso">

                </div>
            </div>
        </div>
    </div>
</section>

<!-- /.modal -->

<div class="modal fade" id="modalExpediente">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
        <div class="modal-header bg-primary">
            <h4 class="modal-title">Derivar Expediente</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form id="frmExpediente" name="frmExpediente" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-4">
                    
                    <div class="form-group">
                    <label>Tipo Doc. Identidad</label>
                    <div class="input-group">
                            <select class="form-control" name="idtipodocumento" id="idtipodocumento" readonly>
                                <?php foreach($documentos as $k=>$v){ ?>
                                <option value="<?= $v['idtipodocumento'];?>"><?= $v['nombre'] ?></option>                                
                                <?php }?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>N° Doc.Identidad</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="nrodocumento" name="nrodocumento" onblur="BuscarClienteDocumento()" readonly/>
                            <span class="input-group-append">
                                <button type="button" class="btn btn-primary" onclick="BuscarClienteDocumento()" >
                                    <span class="fas fa-search"></span>
                                </button>
                            </span>        
                        </div>
                    </div>

                    <div class="form-group">
                            <label>Nombre</label>
                            <input type="text" class="form-control" name="nombre" id="nombre" readonly />
                            <input type="hidden" class="form-control" name="direccion" id="direccion" readonly />
                            <input type="hidden" name="idexpediente" id="idexpediente" />
                            <input type="hidden" name="origen" id="origen" value="EXT" />
                        </div> 
                    <div class="form-group">
                            <label>PROVEIDO</label>
                            <textarea rows="5" class="form-control" name="proveido" id="proveido" ></textarea >
                    </div>

                                       
                    </div>

                    <div class="col-4">
                    <div class="form-group">
                            <label>Tipo Documento</label>
                            <select class="form-control" id="idtipodoc" name="idtipodoc" readonly>
                                <option value="0">Seleccione uno</option>
                                <?php foreach($documentosTR as $k=>$v){ ?>
                                <option value="<?= $v["idtipodoc"] ?>"><?= $v["nombre"] ?></option>
                                <?php }?>
                            </select>
                        </div>     

                        <div class="form-group">
                            <label>Fecha Documento</label>
                            <input type="date" class="form-control" id="fechaexpediente" name="fechaexpediente" value="<?= date('Y-m-d') ?>" readonly/>
                            <input type="hidden" class="form-control" id="fechasys" name="fechasys" value="<?= date('Y-m-d') ?>" />
                        </div>    
                        
                        <div class="form-group">
                            <label>N° Documento</label>
                            <input type="text" class="form-control" name="nroexpediente" id="nroexpediente" readonly/>
                           
                        </div> 

                        <div class="form-group">
                            <label>Área</label>
                            <select class="form-control" id="idareadestino" name="idareadestino">
                                <option value="0">Seleccione uno</option>
                                <?php foreach($areas as $k=>$v){ ?>
                                <option value="<?= $v["idarea"] ?>"><?= $v["nombre"] ?></option>
                                <?php }?>
                            </select>
                        </div>
 
                                  
                       
                    </div>

                    <div class="col-4">
                        <div class="form-group">
                            <label>asunto</label>
                            <textarea rows="5" class="form-control" name="asunto" id="asunto" readonly></textarea >
                        </div>    
                        <div class="form-group">
                            <label>detalle</label>
                            <textarea rows="5" class="form-control" name="detalle" id="detalle" readonly></textarea>
                            <input type="hidden" class="form-control" name="idtramite" id="idtramite" value="1" />
                            <input type="hidden" class="form-control" name="idarea" id="idarea" value="<?= $idArea ?>" />
                        </div> 
                        
     
                       
                    </div>
                </div>
            </form>
        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-primary" onclick="DerivarExpediente()">Derivar</button>
        </div>
        </div>
        <!-- /.modal-content -->
    </div>
<!-- /.modal-dialog -->
</div>

<div class="modal fade" id="modaldocumento">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
        <div class="modal-header bg-primary">
            <h4 class="modal-title">Archivos adjuntos</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-12">
                <div class="form-group">
                       
                        <input type="hidden" name="idexpediente_documento" id="idexpediente_documento" value="0" />
                    </div>
     
                                                              
                </div>
            </div>
            <div id="divListadoExpedientesModal">
            </div>
        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
           
        </div>
        </div>
        <!-- /.modal-content -->
    </div>
<!-- /.modal-dialog -->
</div>

<script>
function listarExpedientes(){
  $.ajax({
    method: "POST",
    url: "vista/expedientesArchivadosListado.php",
    data: {
        filtro: $("#txtFiltroExpediente").val(),
        estado: $("#cboFiltroEstado").val()
      
      }
  }).done(function(resultado){
      $("#divListadoProceso").html(resultado);
  })
}

function listarExpedientesModal(){
  $.ajax({
    method: "POST",
    url: "vista/documentosinternos_listadoModal.php",
    data: {
        filtro: $("#idexpediente_documento").val()
    
      }
  }).done(function(resultado){
      $("#divListadoExpedientesModal").html(resultado);
  })
}

listarExpedientes();