<?php 
include_once("../modelo/TipoDocumentoTramite.php");
$objTipoDocTram = new TipoDocumentoTramite();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$listado = $objTipoDocTram->listarDocumentosTramite("%".$filtro."%",$estado);
?>
<table id="tablaTipoDocumentoTramite" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Estado</th>
            <th>Editar</th>
            <th>Anular</th>
            <th>Eliminar</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==1?"Anular":"Activar";
            $estado = $v['estado']==1?0:1;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idtipodoc'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['estado']==1?"ACTIVO":"INACTIVO"; ?></td>
                <td><button onclick="EditarTipoDocumentoTramite(<?= $v['idtipodoc'] ?>)" class="btn bg-info btn-sm">Editar</button></td>
                <td><button onclick="CambiarEstadoTipoDocumentoTramite(<?= $v['idtipodoc'] ?>,<?= $estado ?>,'<?= $v['nombre'] ?>')" class="btn <?= $bgclass ?> btn-sm"><?= $texto ?></button></td>
                <td><button onclick="CambiarEstadoTipoDocumentoTramite(<?= $v['idtipodoc'] ?>,2,'<?= $v['nombre'] ?>')" class="btn bg-danger btn-sm">Eliminar</button></td>
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaTipoDocumentoTramite').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[1,'asc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaTipoDocumentoTramite_wrapper .col-md-6:eq(0)');

function EditarTipoDocumentoTramite(idtipodoc){
    $.ajax({
        method: "POST",
        url: "controlador/contTipoDocumentoTramite.php",
        data:{
            'proceso': "CONSULTAR",
            'idtipodoc': idtipodoc
        },
        dataType: "json"
    }).done(function(resultado){
        $("#nombre").val(resultado.nombre);
        $("#estado").val(resultado.estado);
        $("#idtipodoc").val(resultado.idtipodoc);
        $("#modalTipoDocumentoTramite").modal('show');
    });
}

function CambiarEstadoTipoDocumentoTramite(idtipodoc, estado, nombre){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> el Tipo de Documento <b>"+nombre+"</b>?";
    accion = "EjecutarCambiarEstadoTipoDocumentoTramite("+idtipodoc+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoTipoDocumentoTramite(idtipodoc,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contTipoDocumentoTramite.php",
        data: {
            'proceso': proceso,
            'idtipodoc': idtipodoc
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarTipoDocumentoTramite();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}

</script>