<section class="content mt-2">
    <div class="container-fluid">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Tipos de Documentos Trámite</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Nombre</span>
                            </div>
                            <input type="text" class="form-control" 
                              placeholder="Tipo Documento" id="txtFiltroTipoDocumentoTramite" name="txtFiltroTipoDocumentoTramite"
                              >
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Estado</span>
                            </div>
                            <select class="form-control" id="cboFiltroEstado" name="cboFiltroEstado" onchange="listarTipoDocumentoTramite();">
                                <option value="">Todos</option>
                                <option value="1">Activos</option>
                                <option value="0">Inactivos</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                     <button type="button" class="btn btn-info" onclick="listarTipoDocumentoTramite();">Buscar</button> 
                     <button type="button" class="btn btn-warning" onclick="NuevoTipoDocumentoTramite()">Nuevo</button>
                    </div>
                </div>
                <div id="divListado">

                </div>
            </div>
        </div>
    </div>
</section>

<!-- /.modal -->

<div class="modal fade" id="modalTipoDocumentoTramite">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
        <div class="modal-header bg-primary">
            <h4 class="modal-title">Tipo Documento</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form id="frmTipoDocumentoTramite" name="frmTipoDocumentoTramite">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label>Nombre</label>
                            <input type="text" class="form-control" name="nombre" id="nombre" />
                            <input type="hidden" name="idtipodoc" id="idtipodoc" />
                        </div>
                        <div class="form-group">
                            <label>Estado</label>
                            <select class="form-control" name="estado" id="estado">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>                        
                    </div>
                </div>
            </form>
        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-primary" onclick="GuardarTipoDocumentoTramite()">Guardar</button>
        </div>
        </div>
        <!-- /.modal-content -->
    </div>
<!-- /.modal-dialog -->
</div>


<script>
function listarTipoDocumentoTramite(){
  $.ajax({
    method: "POST",
    url: "vista/tipoDocumentoTramite_listado.php",
    data: {
        filtro: $("#txtFiltroTipoDocumentoTramite").val(),
        estado: $("#cboFiltroEstado").val() 
      }
  }).done(function(resultado){
      $("#divListado").html(resultado);
  })
}

listarTipoDocumentoTramite();

function GuardarTipoDocumentoTramite(){
    if(!ValidarFormulario()){
        return 0;
    }
    var datos_formulario = $("#frmTipoDocumentoTramite").serializeArray();
    
    if($("#idtipodoc").val()!="" && $("#idtipodoc").val()!="0"){
        datos_formulario.push({name: "proceso", value:"ACTUALIZAR"});
    }else{
        datos_formulario.push({name: "proceso", value:"NUEVO"});
    }
    $.ajax({
        method: "POST",
        url: "controlador/contTipoDocumentoTramite.php",
        data: datos_formulario
    }).done(function(resultado){
       if(resultado==1){
            toastCorrecto("Registro satisfactorio");        
            $("#modalTipoDocumentoTramite").modal('hide');
            $("#frmTipoDocumentoTramite").trigger('reset');        
            listarTipoDocumentoTramite();                     
       }else{
            msjError = resultado==2?"Tipo Documento duplicado":"No se pudo registrar el tipo de documento."
            toastError(msjError); 
       }
    }); 

}

function ValidarFormulario(){
    retorno = true;
    if($("#nombre").val()==""){
        toastError('Ingrese el nombre del tipo de documento.');          
    retorno = false;
    }
    return retorno;
}

function NuevoTipoDocumentoTramite(){
    $("#frmTipoDocumentoTramite").trigger('reset');  
    $("#idtipodoc").val("");  
    $("#modalTipoDocumentoTramite").modal('show');
}
</script>