<?php 
include_once("../modelo/TipoComprobante.php");
include_once("../modelo/TipoDocumento.php");
include_once("../modelo/Moneda.php");

$objTD = new TipoDocumento();
$documentos = $objTD->listarDocumentos();

$objTC = new TipoComprobante();
$comprobantes = $objTC->listarTipoComprobantes();

$objMon = new Moneda();
$monedas = $objMon->listarMonedas();
?>
<section class="content mt-2">
    <div class="container-fluid">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">NUEVA VENTA</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Fecha</span>
                            </div>
                            <input type="date" class="form-control" id="fecha" name="fecha"/>
                            <input type="hidden" id="idventa" name="idventa" />
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Comprobante</span>
                            </div>
                            <select class="form-control" id="idtipocomprobante" name="idtipocomprobante" onchange="obtenerSeries();">
                                <option value="0">- Seleccione uno -</option>
                                <?php foreach($comprobantes as $k=>$v){ ?>
                                <option value="<?= $v['idtipocomprobante']?>"><?= $v['nombre'] ?></option>
                                <?php }?>
                            </select>
                        </div> 
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Serie</span>
                            </div>
                            <select class="form-control" id="serie" name="serie">
                                <option value="0">- Seleccione uno -</option>
                            </select>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Correlativo</span>
                            </div>
                            <input class="form-control" type="text" id="correlativo" name="correlativo" />
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Forma de Pago</span>
                            </div>
                            <select class="form-control" id="serie" name="serie">
                                <option value="C">CONTADO</option>
                                <option value="D">CREDITO</option>
                            </select>
                        </div>                        
                    </div>
                    <div class="col-4">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Tipo Doc</span>
                            </div>
                            <select class="form-control" name="idtipodocumento" id="idtipodocumento">
                                <?php foreach($documentos as $k=>$v){ ?>
                                <option value="<?= $v['idtipodocumento'];?>"><?= $v['nombre'] ?></option>                                
                                <?php }?>
                            </select>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Nro Doc</span>
                            </div>
                            <input type="text" class="form-control" id="nrodocumento" name="nrodocumento"/>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Cliente</span>
                            </div>
                            <input type="text" class="form-control" id="nombre" name="nombre"/>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Dirección</span>
                            </div>
                            <input type="text" class="form-control" id="direccion" name="direccion"/>
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Vencimiento</span>
                                <input type="date" class="form-control" id="vencimiento" name="vencimiento"/>
                            </div>                            
                        </div>                        
                    </div>                    
                    <div class="col-4">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Moneda</span>
                                <select class="form-control" id="moneda" name="moneda">
                                    <?php foreach($monedas as $k=>$v){ ?>
                                        <option value="<?= $v["idmoneda"] ?>"><?= $v["nombre"]?></option>
                                    <?php }?>
                                </select>
                            </div>                            
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Guia Rem.</span>
                                <input type="text" class="form-control" id="guiaremision" name="guiaremision"/>
                            </div>                            
                        </div>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">Orden Compra</span>
                                <input type="text" class="form-control" id="ordencompra" name="ordencompra"/>
                            </div>                            
                        </div>                                                 
                    </div>
                </div>
                <div id="divListado">

                </div>
            </div>
        </div>
    </div>
</section>
</div>
<script>
function obtenerSeries(){
    $.ajax({
        method: "POST",
        url: "controlador/contVenta.php",
        data:{
            'proceso': "SERIES",
            'idtipocomprobante': $("#idtipocomprobante").val()
        },
        dataType: 'json'
    }).done(function(resultado){
        series = "";
        for(i=0;i<resultado.length;i++){
            series = series + "<option value='"+resultado[i].serie+"'>"+resultado[i].serie+"</option>"; 
        }
        $("#serie").html(series);
    });
}
</script>